<?php

namespace App\DataTables\Admin;

use App\Models\User;
use Illuminate\Database\Eloquent\Builder as QueryBuilder;
use Yajra\DataTables\Html\Builder as HtmlBuilder;
use Yajra\DataTables\Html\Column;
use Yajra\DataTables\Services\DataTable;
use Yajra\DataTables\EloquentDataTable;

class StaffDataTable extends DataTable
{public function dataTable(QueryBuilder $query): EloquentDataTable
    {
        return (new EloquentDataTable($query))
            ->addIndexColumn()
            ->addColumn('image', function ($staff) {
                return view('admin.staff.image', compact('staff'));
            })
            ->addColumn('name', function ($staff) {
                return $staff->first_name.' '.$staff->last_name;
            })
            ->addColumn('phone', function ($staff) {
                return $staff->phone;
            })
            ->addColumn('email', function ($staff) {
                return $staff->email;
            })
            ->addColumn('last_login', function ($staff) {
                return 4;
            })
            ->addColumn('created_at', function ($staff) {
                return date('d M Y', strtotime($staff->created_at));
            })
            ->addColumn('status', function ($staff) {
                return view('admin.staff.status', compact('staff'));
            })
            ->addColumn('option', function ($staff) {
                return view('admin.staff.action', compact('staff'));
            })
            ->setRowId('id');
    }

	public function query(): QueryBuilder
	{
		$search = request('search.value');
        return User::where('user_type','staff')->when($this->request->search['value'] ?? false, function ($query) {
            $search = $this->request->search['value'];
            $query->where('last_name', 'like', "%$search%")
                ->orWhere('email', 'like', "%$search%")
                ->orWhere('phone', 'like', "%$search%")
                ->orWhere('first_name', 'like', "%$search%");
        })
        ->latest()
        ->newQuery();
	}

	public function html(): HtmlBuilder
    {
        return $this->builder()
            ->columns($this->getColumns())
            ->minifiedAjax()
            ->orderBy(1)
            ->selectStyleSingle()
            ->setTableAttribute('style', 'width:99.8%')
            ->footerCallback('function ( row, data, start, end, display ) {

                $(".dataTables_length select").addClass("form-select form-select-lg without_search mb-3");
                selectionFields();
            }')
            ->parameters([
                'dom'        => 'Blfrtip',
                'buttons'    => [
                    [],
                ],
                'lengthMenu' => [[10, 25, 50, 100, 250], [10, 25, 50, 100, 250]],
                'language'   => [
                    'searchPlaceholder' => __('search'),
                    'lengthMenu'        => '_MENU_ '.__('staff_per_page'),
                    'search'            => '',
                ],
            ]);
    }

    public function getColumns(): array
    {
        return [
			Column::computed('id')->data('DT_RowIndex')->title('#')->searchable(false)->width(10),
            Column::computed('image')->title(__('image')),
            Column::computed('name')->title(__('name')),
            Column::computed('phone')->title(__('phone')),
            Column::computed('email')->title(__('email')),
            Column::computed('last_login')->title(__('last_login')),
            Column::computed('created_at')->title(__('created_at')),
            Column::computed('status')->title(__('status')),
            Column::computed('option')->title(__('option')),
           
        ];
    }

    protected function filename(): string
    {
        return 'Currency_'.date('YmdHis');
    }


}