<?php

namespace App\DataTables\Admin;

use App\Models\Package;
use Illuminate\Database\Eloquent\Builder as QueryBuilder;
use Yajra\DataTables\Html\Builder as HtmlBuilder;
use Yajra\DataTables\Html\Column;
use Yajra\DataTables\Services\DataTable;
use Yajra\DataTables\EloquentDataTable;

class PackageDataTable extends DataTable
{public function dataTable(QueryBuilder $query): EloquentDataTable
    {
        return (new EloquentDataTable($query))
            ->addIndexColumn()
            ->addColumn('name', function ($package) {
                return $package->name;
            })
            ->addColumn('day', function ($package) {
                return $package->day.' '.__('days');
            })
            ->addColumn('type', function ($package) {
                return ucwords($package->type);
            })
            ->addColumn('price', function ($package) {
                return view('admin.package.price', compact('package'));
            })
            ->addColumn('status', function ($package) {
                return view('admin.package.status', compact('package'));
            })
            ->addColumn('option', function ($package) {
                return view('admin.package.action', compact('package'));
            })
            ->setRowId('id');
    }

	public function query(): QueryBuilder
	{
        return Package::when($this->request->search['value'] ?? false, function ($query) {
            $search = $this->request->search['value'];
            $query->where('name', 'like', "%$search%")
                ->orWhere('price', 'like', "%$search%")
                ->orWhere('screens', 'like', "%$search%")
                ->orWhere('day', 'like', "%$search%");
        })
        ->latest()
        ->newQuery();
	}

	public function html(): HtmlBuilder
    {
        return $this->builder()
            ->columns($this->getColumns())
            ->minifiedAjax()
            ->orderBy(1)
            ->selectStyleSingle()
            ->setTableAttribute('style', 'width:99.8%')
            ->footerCallback('function ( row, data, start, end, display ) {

                $(".dataTables_length select").addClass("form-select form-select-lg without_search mb-3");
                selectionFields();
            }')
            ->parameters([
                'dom'        => 'Blfrtip',
                'buttons'    => [
                    [],
                ],
                'lengthMenu' => [[10, 25, 50, 100, 250], [10, 25, 50, 100, 250]],
                'language'   => [
                    'searchPlaceholder' => __('search'),
                    'lengthMenu'        => '_MENU_ '.__('package_per_page'),
                    'search'            => '',
                ],
            ]);
    }

    public function getColumns(): array
    {
        return [
			Column::computed('id')->data('DT_RowIndex')->title('#')->searchable(false)->width(10),
            Column::computed('name')->title(__('name')),
            Column::computed('day')->title(__('day')),
            Column::computed('price')->title(__('price')),
            Column::computed('type')->title(__('type')),
            Column::computed('status')->title(__('status')),
            Column::computed('option')->title(__('option')),
           
        ];
    }

    protected function filename(): string
    {
        return 'Currency_'.date('YmdHis');
    }


}