<?php

namespace App\DataTables\Admin;

use App\Models\MovieFile;
use Illuminate\Database\Eloquent\Builder as QueryBuilder;
use Yajra\DataTables\Html\Builder as HtmlBuilder;
use Yajra\DataTables\Html\Column;
use Yajra\DataTables\Services\DataTable;
use Yajra\DataTables\EloquentDataTable;

class MovieFileDataTable extends DataTable
{public function dataTable(QueryBuilder $query): EloquentDataTable
    {
        return (new EloquentDataTable($query))
            ->addIndexColumn()
            ->addColumn('label', function ($file) {
                return $file->label;
            })
            ->addColumn('file_source', function ($file) {
                return $file->file_source;
            })
            ->addColumn('source_type', function ($file) {
                return $file->source_type;
            })
            ->addColumn('order', function ($file) {
                return $file->order;
            })
            ->addColumn('file_url', function ($file) {
                return $file->file_url;
            })
            ->addColumn('option', function ($file) {
                return view('admin.movies.video.action', compact('file'));
            })
            ->setRowId('id');
    }

	public function query(): QueryBuilder
	{
        return MovieFile::where('video_id', $this->movie_id)->when($this->request->search['value'] ?? false, function ($query) {
            $search = $this->request->search['value'];
            $query->where('label', 'like', "%$search%");
        })
        ->latest()
        ->newQuery();
	}

	public function html(): HtmlBuilder
    {
        return $this->builder()
            ->columns($this->getColumns())
            ->minifiedAjax()
            ->orderBy(1)
            ->selectStyleSingle()
            ->setTableAttribute('style', 'width:99.8%')
            ->footerCallback('function ( row, data, start, end, display ) {

                $(".dataTables_length select").addClass("form-select form-select-lg without_search mb-3");
                selectionFields();
            }')
            ->parameters([
                'dom'        => 'Blfrtip',
                'buttons'    => [
                    [],
                ],
                'lengthMenu' => [[10, 25, 50, 100, 250], [10, 25, 50, 100, 250]],
                'language'   => [
                    'searchPlaceholder' => __('search'),
                    'lengthMenu'        => '_MENU_ '.__('movie_files_per_page'),
                    'search'            => '',
                ],
            ]);
    }

    public function getColumns(): array
    {
        return [
			Column::computed('id')->data('DT_RowIndex')->title('#')->searchable(false)->width(10),
            Column::computed('label')->title(__('label')),
            Column::computed('file_source')->title(__('file_source')),
            Column::computed('source_type')->title(__('source_type')),
            Column::computed('order')->title(__('order')),
            Column::computed('file_url')->title(__('file_url')),
            Column::computed('option')->title(__('option')),
           
        ];
    }

    protected function filename(): string
    {
        return 'Currency_'.date('YmdHis');
    }


}