<?php

namespace App\DataTables\Admin;

use App\Models\Ads;
use Illuminate\Database\Eloquent\Builder as QueryBuilder;
use Yajra\DataTables\Html\Builder as HtmlBuilder;
use Yajra\DataTables\Html\Column;
use Yajra\DataTables\Services\DataTable;
use Yajra\DataTables\EloquentDataTable;

class MidRollAdsDataTable extends DataTable
{public function dataTable(QueryBuilder $query): EloquentDataTable
    {
        return (new EloquentDataTable($query))
            ->addIndexColumn()
            ->addColumn('question', function ($ads) {
                return $ads->question;
            })
             ->addColumn('total_views', function ($ads) {
                return $ads->total_views;
            })
            ->addColumn('ad_duration', function ($ads) {
                return $ads->ad_duration. ' ' . __('seconds');
            })
            ->addColumn('skip_after', function ($ads) {
                return $ads->skip_after. ' ' . __('seconds');
            })
            ->addColumn('status', function ($ads) {
                return view('admin.ads.status', compact('ads'));
            })
            ->addColumn('option', function ($ads) {
                return view('admin.ads.mid_roll.action', compact('ads'));
            })
            ->setRowId('id');
    }

	public function query(): QueryBuilder
	{
		$search = request('search.value');
        return Ads::when($this->request->search['value'] ?? false, function ($query) {
            $search = $this->request->search['value'];
            $query->where('title', 'like', "%$search%");
        })->whereIn('type', ['mid_roll'])
        ->latest()
        ->newQuery();
	}

	public function html(): HtmlBuilder
    {
        return $this->builder()
            ->columns($this->getColumns())
            ->minifiedAjax()
            ->orderBy(1)
            ->selectStyleSingle()
            ->setTableAttribute('style', 'width:99.8%')
            ->footerCallback('function ( row, data, start, end, display ) {

                $(".dataTables_length select").addClass("form-select form-select-lg without_search mb-3");
                selectionFields();
            }')
            ->parameters([
                'dom'        => 'Blfrtip',
                'buttons'    => [
                    [],
                ],
                'lengthMenu' => [[10, 25, 50, 100, 250], [10, 25, 50, 100, 250]],
                'language'   => [
                    'searchPlaceholder' => __('search'),
                    'lengthMenu'        => '_MENU_ '.__('mid_roll_ads_per_page'),
                    'search'            => '',
                ],
            ]);
    }

    public function getColumns(): array
    {
        return [
			Column::computed('id')->data('DT_RowIndex')->title('#')->width(10),
            Column::computed('title')->title(__('title')),
            Column::computed('ad_duration')->title(__('ad_duration')),
            Column::computed('skip_after')->title(__('skip_after')),
            Column::computed('status')->title(__('status')),
            Column::computed('option')->title(__('option')),
           
        ];
    }

    protected function filename(): string
    {
        return 'Currency_'.date('YmdHis');
    }


}