<?php

namespace App\DataTables\Admin;

use App\Models\Genre;
use Illuminate\Database\Eloquent\Builder as QueryBuilder;
use Yajra\DataTables\Html\Builder as HtmlBuilder;
use Yajra\DataTables\Html\Column;
use Yajra\DataTables\Services\DataTable;
use Yajra\DataTables\EloquentDataTable;

class GenreDataTable extends DataTable
{public function dataTable(QueryBuilder $query): EloquentDataTable
    {
        return (new EloquentDataTable($query))
            ->addIndexColumn()
            ->addColumn('icon', function ($genre) {
                return view('admin.genre.image', compact('genre'));
            })
            ->addColumn('name', function ($genre) {
                return $genre->name;
            })
            ->addColumn('slug', function ($genre) {
                return $genre->slug;
            })
            ->addColumn('description', function ($genre) {
                return $genre->description;
            })
            ->addColumn('status', function ($genre) {
                return view('admin.genre.status', compact('genre'));
            })
            ->addColumn('featured', function ($genre) {
                return view('admin.genre.featured', compact('genre'));
            })
            ->addColumn('option', function ($genre) {
                return view('admin.genre.action', compact('genre'));
            })
            ->setRowId('id');
    }

	public function query(): QueryBuilder
	{
		$search = request('search.value');
        return Genre::when($this->request->search['value'] ?? false, function ($query) {
            $search = $this->request->search['value'];
            $query->where('name', 'like', "%$search%")
                ->orWhere('slug', 'like', "%$search%");
        })
        ->latest()
        ->newQuery();
	}

	public function html(): HtmlBuilder
    {
        return $this->builder()
            ->columns($this->getColumns())
            ->minifiedAjax()
            ->orderBy(1)
            ->selectStyleSingle()
            ->setTableAttribute('style', 'width:99.8%')
            ->footerCallback('function ( row, data, start, end, display ) {

                $(".dataTables_length select").addClass("form-select form-select-lg without_search mb-3");
                selectionFields();
            }')
            ->parameters([
                'dom'        => 'Blfrtip',
                'buttons'    => [
                    [],
                ],
                'lengthMenu' => [[10, 25, 50, 100, 250], [10, 25, 50, 100, 250]],
                'language'   => [
                    'searchPlaceholder' => __('search'),
                    'lengthMenu'        => '_MENU_ '.__('genre_per_page'),
                    'search'            => '',
                ],
            ]);
    }

    public function getColumns(): array
    {
        return [
			Column::computed('id')->data('DT_RowIndex')->title('#')->width(10),
            Column::computed('icon')->title(__('icon')),
            Column::computed('name')->title(__('name')),
            Column::computed('slug')->title(__('slug')),
            Column::computed('description')->title(__('description')),
            Column::computed('featured')->title(__('featured')),
            Column::computed('status')->title(__('status')),
            Column::computed('option')->title(__('option')),
           
        ];
    }

    protected function filename(): string
    {
        return 'Currency_'.date('YmdHis');
    }


}