<?php

namespace App\DataTables\Admin;

use App\Models\Country;
use Illuminate\Database\Eloquent\Builder as QueryBuilder;
use Yajra\DataTables\Html\Builder as HtmlBuilder;
use Yajra\DataTables\Html\Column;
use Yajra\DataTables\Services\DataTable;
use Yajra\DataTables\EloquentDataTable;

class CountryDataTable extends DataTable
{public function dataTable(QueryBuilder $query): EloquentDataTable
    {
        return (new EloquentDataTable($query))
            ->addIndexColumn()
            ->addColumn('flag', function ($country) {
                return view('admin.country.image', compact('country'));
            })
            ->addColumn('name', function ($country) {
                return $country->name;
            })
            ->addColumn('slug', function ($country) {
                return $country->slug;
            })
            ->addColumn('description', function ($country) {
                return $country->description;
            })
            ->addColumn('status', function ($country) {
                return view('admin.country.status', compact('country'));
            })
            ->addColumn('option', function ($country) {
                return view('admin.country.action', compact('country'));
            })
            ->setRowId('id');
    }

	public function query(): QueryBuilder
	{
        return Country::when($this->request->search['value'] ?? false, function ($query) {
            $search = $this->request->search['value'];
            $query->where('video_type', 'like', "%$search%")
                ->orWhere('video_type_desc', 'like', "%$search%");
        })
        ->latest()
        ->newQuery();
	}

	public function html(): HtmlBuilder
    {
        return $this->builder()
            ->columns($this->getColumns())
            ->minifiedAjax()
            ->orderBy(1)
            ->selectStyleSingle()
            ->setTableAttribute('style', 'width:99.8%')
            ->footerCallback('function ( row, data, start, end, display ) {

                $(".dataTables_length select").addClass("form-select form-select-lg without_search mb-3");
                selectionFields();
            }')
            ->parameters([
                'dom'        => 'Blfrtip',
                'buttons'    => [
                    [],
                ],
                'lengthMenu' => [[10, 25, 50, 100, 250], [10, 25, 50, 100, 250]],
                'language'   => [
                    'searchPlaceholder' => __('search'),
                    'lengthMenu'        => '_MENU_ '.__('country_per_page'),
                    'search'            => '',
                ],
            ]);
    }

    public function getColumns(): array
    {
        return [
			Column::computed('id')->data('DT_RowIndex')->title('#')->searchable(false)->width(10),
            Column::computed('flag')->title(__('flag')),
            Column::computed('name')->title(__('name')),
            Column::computed('slug')->title(__('slug')),
            Column::computed('description')->title(__('description')),
            Column::computed('status')->title(__('status')),
            Column::computed('option')->title(__('option')),
           
        ];
    }

    protected function filename(): string
    {
        return 'Currency_'.date('YmdHis');
    }


}