<?php

namespace App\DataTables\Admin;

use App\Models\Category;
use Illuminate\Database\Eloquent\Builder as QueryBuilder;
use Yajra\DataTables\Html\Builder as HtmlBuilder;
use Yajra\DataTables\Html\Column;
use Yajra\DataTables\Services\DataTable;
use Yajra\DataTables\EloquentDataTable;

class CategoryDataTable extends DataTable
{public function dataTable(QueryBuilder $query): EloquentDataTable
    {
        return (new EloquentDataTable($query))
            ->addIndexColumn()
            ->addColumn('video_type', function ($category) {
                return $category->video_type;
            })
            ->addColumn('video_type_desc', function ($category) {
                return $category->video_type_desc;
            })
            ->addColumn('primary_menu', function ($category) {
                return view('admin.category.primary_menu', compact('category'));
            })
            ->addColumn('footer_menu', function ($category) {
                return view('admin.category.footer_menu', compact('category'));
            })
            ->addColumn('views', function ($movie) {
                return 0;
            })
            ->addColumn('option', function ($category) {
                return view('admin.category.action', compact('category'));
            })
            ->setRowId('id');
    }

	public function query(): QueryBuilder
	{
        return Category::when($this->request->search['value'] ?? false, function ($query) {
            $search = $this->request->search['value'];
            $query->where('video_type', 'like', "%$search%");
        })
        ->latest()
        ->newQuery();
	}

	public function html(): HtmlBuilder
    {
        return $this->builder()
            ->columns($this->getColumns())
            ->minifiedAjax()
            ->orderBy(1)
            ->selectStyleSingle()
            ->setTableAttribute('style', 'width:99.8%')
            ->footerCallback('function ( row, data, start, end, display ) {

                $(".dataTables_length select").addClass("form-select form-select-lg without_search mb-3");
                selectionFields();
            }')
            ->parameters([
                'dom'        => 'Blfrtip',
                'buttons'    => [
                    [],
                ],
                'lengthMenu' => [[10, 25, 50, 100, 250], [10, 25, 50, 100, 250]],
                'language'   => [
                    'searchPlaceholder' => __('search'),
                    'lengthMenu'        => '_MENU_ '.__('video_type_per_page'),
                    'search'            => '',
                ],
            ]);
    }

    public function getColumns(): array
    {
        return [
			Column::computed('id')->data('DT_RowIndex')->title('#')->searchable(false)->width(10),
            Column::computed('video_type')->title(__('name')),
            Column::computed('video_type_desc')->title(__('description')),
            Column::computed('primary_menu')->title(__('primary_menu')),
            Column::computed('footer_menu')->title(__('footer_menu')),
            Column::computed('option')->title(__('option')),
           
        ];
    }

    protected function filename(): string
    {
        return 'Currency_'.date('YmdHis');
    }


}